import { action } from '@storybook/addon-actions';
import { Meta } from '@storybook/react';
import { InputField2 } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { object, string } from 'yup';

import { FormPage } from './FormPage';

const initialValue = {
   id: 'xx',
   name: 'yyy',
};
type FormParams = typeof initialValue;
const validationSchema = object<FormParams>({
   id: string().required(),
   name: string().required(),
});

export const Regular = () => (
   <>
      <header style={{ height: 45, backgroundColor: 'yellow' }}>header placeholder</header>
      <FormPage
         cancelButtonText={'Cancel'}
         subTitle={'New release rule'}
         submitButtonText={'Create'}
         title={'New sandbox rule'}
         onSubmit={action('onSubmit')}
         onCancel={action('onCancel')}
         initialValues={initialValue}
         validationSchema={validationSchema}
      >
         {() => (
            <>
               <InputField2 name={'id'} label={'ID'} />
               <InputField2 name={'name'} label={'Name'} />
            </>
         )}
      </FormPage>
   </>
);

export default {
   title: 'components/layout/FormPage',
} as Meta;
