import { action } from '@storybook/addon-actions';
import { boolean, text } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import React from 'react';

import { FormPageLayout } from './FormPageLayout';

export const WithMiddle = () => (
   <>
      <header style={{ height: 45, backgroundColor: 'yellow' }}>header placeholder</header>
      <FormPageLayout
         cancelButtonText={text('cancelButtonText', 'Cancel')}
         disabled={boolean('disabled', true)}
         hideContentPaddings={boolean('hideContentPaddings', false)}
         onCancel={action('onCancel')}
         submitButtonText={text('submitButtonText', 'Create')}
         supTitle={text('subTitle', 'New release rule')}
         title={text('title', 'New sandbox rule')}
         middleNode={text('middleNode', 'middleNode')}
      >
         This is CONTENT!!!
      </FormPageLayout>
   </>
);

export const Regular = () => (
   <>
      <header style={{ height: 45, backgroundColor: 'yellow' }}>header placeholder</header>
      <FormPageLayout
         cancelButtonText={text('cancelButtonText', 'Cancel')}
         disabled={boolean('disabled', true)}
         hideContentPaddings={boolean('hideContentPaddings', false)}
         onCancel={action('onCancel')}
         submitButtonText={text('submitButtonText', 'Create')}
         supTitle={text('subTitle', 'New release rule')}
         title={text('title', 'New sandbox rule')}
      >
         This is CONTENT!!!
      </FormPageLayout>
   </>
);

export default {
   title: 'components/layout/FormPageLayout',
} as Meta;
