import { classNames } from '@yandex-infracloud-ui/libs';
import React, { ReactNode } from 'react';

import { LegoButton } from '../../../_lego';

import classes from './FormPageLayout.module.css';

interface Props {
   buttonsBefore?: ReactNode;
   cancelButtonText: ReactNode;
   cancelDisabled?: boolean;
   className?: string;
   disabled: boolean;
   hideContentPaddings: boolean;
   middleNode?: ReactNode;
   submitButtonText: ReactNode;
   supTitle: ReactNode;
   title: ReactNode;

   onSubmit?(): void;

   onCancel(): void;
}

export const FormPageLayout: React.FC<Props> = ({
   buttonsBefore,
   cancelButtonText,
   cancelDisabled = false,
   children,
   className,
   disabled,
   hideContentPaddings,
   middleNode,
   onCancel,
   onSubmit,
   submitButtonText,
   supTitle,
   title,
}) => (
   <div
      className={classNames(classes.formPage, className, { [classes.hidePaddings]: hideContentPaddings })}
      data-e2e={'FormPageLayout'}
   >
      <header className={classes.header} data-e2e={'FormPageLayout:Header'}>
         <div className={classes.supTitle}>{supTitle}</div>
         <div className={classes.titleWithButtons}>
            <h1 className={classes.title} data-e2e={'FormPageLayout:Title'}>
               {title}
            </h1>

            {middleNode ? <div>{middleNode}</div> : null}

            <div className={classes.buttons} data-e2e={'FormPageLayout:Buttons'}>
               {buttonsBefore}
               <LegoButton
                  onClick={onCancel}
                  disabled={cancelDisabled}
                  controlAttrs={{ 'data-e2e': 'FormPageLayout:CancelButton' }}
               >
                  {cancelButtonText}
               </LegoButton>
               <LegoButton
                  theme={'action'}
                  type={onSubmit ? undefined : 'submit'}
                  disabled={disabled}
                  onClick={onSubmit}
                  controlAttrs={{ 'data-e2e': 'FormPageLayout:SubmitButton' }}
               >
                  {submitButtonText}
               </LegoButton>
            </div>
         </div>
      </header>

      <div className={classes.main}>{children}</div>
   </div>
);

FormPageLayout.displayName = 'FormPageLayout';
