import { Meta } from '@storybook/react';
import React from 'react';

import { Page } from './Page';

export const WithoutHeader = () => (
   <Page>
      <div style={{ backgroundColor: 'yellow', height: 1000 }}>content 1000px</div>
   </Page>
);

export const WithHeader = () => (
   <Page header={<h1>Header</h1>}>
      <div style={{ backgroundColor: 'yellow', height: 1000 }}>content 1000px</div>
   </Page>
);

export default {
   decorators: [(story: any) => <div style={{ ['--side-padding' as any]: '2rem' } as any}>{story()}</div>],
   title: 'components/layout/Page',
} as Meta;
