import { faRobot } from '@fortawesome/pro-regular-svg-icons';
import { Meta } from '@storybook/react';
import React from 'react';

import { Badge, BadgeType } from './Badge';

export const AllTypes = () => (
   <>
      {Object.entries(BadgeType).map(([k, v]) => (
         <div key={k}>
            <Badge type={v}>{k}</Badge>
         </div>
      ))}
   </>
);

export const OneUpdate = () => <Badge type={BadgeType.Warning}>1 update</Badge>;

export const Multiple = () => (
   <>
      <Badge type={BadgeType.Warning}>1 update</Badge>
      <Badge type={BadgeType.Warning}>21 tickets</Badge>
      <Badge type={BadgeType.Error}>3 errors</Badge>
      <Badge type={BadgeType.Success}>5 patches</Badge>
   </>
);

export const CustomIcon = () => (
   <Badge type={BadgeType.Warning} icon={faRobot}>
      1 update
   </Badge>
);

export const NoIcon = () => (
   <Badge type={BadgeType.Warning} icon={null}>
      1 update
   </Badge>
);

export default {
   title: 'components/lib/Badge',
} as Meta;
