import React from 'react';

import { faBell, faCheck, faExclamationTriangle, IconDefinition } from '@fortawesome/free-solid-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { classNames } from '@yandex-infracloud-ui/libs';

import classes from './Badge.module.css';

export enum BadgeType {
   Success = 'success',
   Warning = 'warning',
   Error = 'error',
}

const icons = new Map([
   [BadgeType.Success, faCheck],
   [BadgeType.Warning, faBell],
   [BadgeType.Error, faExclamationTriangle],
]);

interface Props {
   className?: string;
   icon?: IconDefinition | null;
   title?: string;
   type: BadgeType;
   'data-e2e'?: string;
}

export const Badge: React.FC<Props> = ({ className, icon, type, title, children, 'data-e2e': dataE2e }) => (
   <span
      className={classNames(classes.badge, className, classes[type], {
         [classes.noIcon]: icon === null,
      })}
      title={title ?? ''}
      data-e2e={dataE2e}
   >
      {icon === null ? null : <FontAwesomeIcon icon={icon ?? icons.get(type)!} className={classes.icon} />}

      {children}
   </span>
);

Badge.displayName = 'Badge';
