import { action } from '@storybook/addon-actions';
import { Meta } from '@storybook/react';
import { modalService } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React, { ReactNode, useCallback, useState } from 'react';

import { modalsSupportDecorator } from '../../../stories';
// noinspection TypeScriptPreferShortImport
import { DevJson } from '../DevJson/DevJson';

import { ConfirmModal } from './ConfirmModal';

export const Regular = () => <ConfirmModal title={'Confirm title'} cancel={action('cancel')} ok={action('ok')} />;

export const OpenModal = () => {
   const [result, setResult] = useState(false);

   const open = useCallback(() => {
      modalService
         .open(ConfirmModal, {
            title: 'Confirm title2' as ReactNode, // TODO avoid cast
            subtitle: 'confirm subtitle' as ReactNode,
         })
         .subscribe(
            r => {
               console.log('success', r);
               setResult(r);
            },
            e => {
               console.log('error', e);
            },
         );
   }, []);

   return (
      <>
         <Button theme={'normal'} size={'s'} onClick={open}>
            Open
         </Button>
         <DevJson open={true}>{result}</DevJson>
      </>
   );
};

export default {
   decorators: [modalsSupportDecorator],
   title: 'components/lib/ConfirmModal',
} as Meta;
