import { IModalProps, ModalLayout } from '@yandex-infracloud-ui/libs';
import React, { ReactNode, useCallback } from 'react';

interface Props extends IModalProps<boolean> {
   subtitle?: ReactNode;
   title: ReactNode;
}

export const ConfirmModal: React.FC<Props> = React.memo(({ title, subtitle, ok }) => {
   const handleOk = useCallback(() => ok(true), [ok]);
   const handleClose = useCallback(() => ok(false), [ok]);

   return <ModalLayout title={title} subtitle={subtitle} onOk={handleOk} onDismiss={handleClose} />;
});

ConfirmModal.displayName = 'ConfirmModal';
