import React, { ReactNode } from 'react';

import { ClipboardButton } from '@yandex-cloud/uikit';
import { classNames } from '@yandex-infracloud-ui/libs';

import { handleStopPropagation } from '../../../utils';

import classes from './CopyWrapper.module.css';

export interface CopyWrapperProps {
   text?: string;
   className?: string;
   showByHover?: boolean;
}
export const CopyWrapper: React.FC<CopyWrapperProps> = ({ children, text, className, showByHover = false }) => {
   let copyText: string | null = text ?? null;
   if (typeof children === 'string' || typeof children === 'number') {
      if (!copyText) {
         copyText = children.toString();
      }
   }

   return (
      <span className={classNames(classes.text, className)}>
         {children}{' '}
         {copyText && (
            <span onClick={handleStopPropagation} role={'button'} tabIndex={0}>
               <ClipboardButton
                  text={copyText}
                  size={14}
                  className={classNames(classes.copyButton, { [classes.byHover]: showByHover })}
               />
            </span>
         )}
      </span>
   );
};

CopyWrapper.displayName = 'CopyWrapper';

export const wrapCopy = (content?: ReactNode, text?: string) =>
   content ? React.createElement(CopyWrapper, { text }, content) : null;
