import React, { ReactNode } from 'react';
import { classNames } from '@yandex-infracloud-ui/libs';

import classes from './DefinitionList.module.css';
import { CopyWrapper } from '../CopyWrapper/CopyWrapper';

export interface DefinitionListItem {
   name: string;
   content?: ReactNode;
   title?: string;
   copyText?: boolean | string;
}

interface DefinitionListProps {
   items: DefinitionListItem[];
   responsive?: boolean;
   className?: string;
}

const getTitle = (title?: string, content?: ReactNode) => {
   if (title) {
      return title;
   }

   if (typeof content === 'string' || typeof content === 'number') {
      return String(content);
   }

   return undefined;
};

const DefinitionListItemView: React.FC<{ item: DefinitionListItem }> = ({ item }) => {
   const { name, content, title, copyText } = item;
   if (content === undefined || content === null || content === '') {
      return null;
   }

   let definitionContent;
   if (copyText) {
      if (typeof copyText === 'boolean') {
         definitionContent = <CopyWrapper>{content}</CopyWrapper>;
      } else {
         definitionContent = <CopyWrapper text={copyText}>{content}</CopyWrapper>;
      }
   } else {
      definitionContent = typeof content === 'boolean' ? content.toString() : content;
   }

   return (
      <div key={title} className={classes.item}>
         <div className={classes['term-container']}>
            <dt className={classes.term} title={name}>
               {name}
            </dt>
            <div className={classes.dots} />
         </div>
         <dd className={classes.definition} title={getTitle(title, content)}>
            {definitionContent}
         </dd>
      </div>
   );
};

export const DefinitionList: React.FunctionComponent<DefinitionListProps> = ({ items, responsive, className }) => (
   <dl className={classNames(classes.definitionList, responsive ? classes.responsive : undefined, className)}>
      {items.map((item, i) => (
         <DefinitionListItemView item={item} key={`${item.name}-${i + 1}`} />
      ))}
   </dl>
);

DefinitionList.displayName = 'DefinitionList';
