import { json } from '@yandex-infracloud-ui/libs';
import React from 'react';

// noinspection ES6PreferShortImport (circular)
import { useConfig } from '../../../services/Config';

import classes from './DevJson.module.css';

interface Props {
   open?: boolean;
   summary?: string;
}

export const DevJson: React.FC<Props> = ({ open = false, summary = 'Show JSON', children }) => {
   const config = useConfig(true);
   const needToShow = config ? config.showDevJson() : true;
   if (!needToShow) {
      return null;
   }

   return (
      <details open={open}>
         <summary>{summary}</summary>
         <pre className={classes.devJson}>{json(children)}</pre>
      </details>
   );
};

DevJson.displayName = 'DevJson';
