import { Meta } from '@storybook/react';
import { deepClone } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { stageHugeFormStage } from '../../../stories';
import { toYaml } from '../../../utils';

import { DiffView } from './DiffView';

// eslint-disable-next-line
const modifiedStage = deepClone(stageHugeFormStage);

modifiedStage.spec!.deploy_units.deployUnit.revision += 1;
modifiedStage.spec!.deploy_units.DeployUnit1.revision += 1;

const original = toYaml(stageHugeFormStage);
const modified = toYaml(modifiedStage);

export const Regular = () => (
   <DiffView
      language={'yaml'}
      leftToolbar={<>left toolbar content</>}
      rightToolbar={<>right</>}
      modified={modified}
      original={original}
   />
);

export default {
   title: 'components/lib/DiffView',
} as Meta;
