import { IconDefinition } from '@fortawesome/fontawesome-svg-core';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { classNames } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React from 'react';

import classes from './FadeButton.module.css';

interface Props {
   className?: string;
   disabled?: boolean;
   icon?: IconDefinition;
   text: string;

   onClick(): void;
}

export const FadeButton: React.FC<Props> = React.memo(({ className, disabled = false, text, icon, onClick }) => (
   <Button
      key={text}
      theme={'clear'}
      size={'s'}
      cls={classNames(classes.button, className)}
      disabled={disabled}
      onClick={onClick}
   >
      {icon ? <FontAwesomeIcon className={classes.icon} icon={icon} /> : null} {text}
   </Button>
));

FadeButton.displayName = 'FadeButton';
