import { classNames } from '@yandex-infracloud-ui/libs';
import React from 'react';

import classes from './FixedBlock.module.css';

interface Props {
   position: 'top' | 'bottom' | 'left' | 'right';
   className?: string;
}

export const FixedBlock: React.FC<Props> = React.memo(({ position, children, className }) => (
   <div className={classNames(classes.fixed, className, { [classes[position]]: true })}>{children}</div>
));

FixedBlock.displayName = 'FixedBlock';
