import { Meta, Story } from '@storybook/react';
import React from 'react';

import { HierarchicalTable } from './HierarchicalTable';
import { HierarchicalTableConfig, LevelConfig } from './publicModels';

interface Usage {
   key: string;
   path: string;
}

interface Version {
   usages: Usage[];
   versionId: string;
}

interface Secret {
   name: string;
   secretId: string;
   versions: Version[];
}

const values: Secret[] = [
   {
      secretId: 'secret1',
      name: 'Secret1',
      versions: [
         {
            versionId: 'Version1',
            usages: [
               { key: 'key0', path: 'path0' },
               { key: 'key1', path: 'path1' },
               { key: 'key2', path: 'path2' },
               { key: 'key3', path: 'path3' },
            ],
         },
         {
            versionId: 'Version2',
            usages: [
               { key: 'key0', path: 'path0' },
               { key: 'key1', path: 'path2' },
               { key: 'key2', path: 'path3' },
            ],
         },
      ],
   },
   {
      secretId: 'secret2',
      name: 'Secret2',
      versions: [
         {
            versionId: 'Version11',
            usages: [
               { key: 'key0', path: 'path0' },
               { key: 'key1', path: 'path1' },
            ],
         },
         {
            versionId: 'Version22',
            usages: [{ key: 'key0', path: 'path0' }],
         },
      ],
   },
];

interface Context {
   hideUsages: boolean;
}

const context: Context = {
   hideUsages: false,
};

const config: HierarchicalTableConfig = {
   addCheckbox: true,
   levels: [
      {
         id: 'secret',
         columns: [{ id: 'secret', head: 'Secret', render: v => v.name }],
         getChildren: v => v.versions,
         getId: v => v.secretId,
      } as LevelConfig<void, Secret, Version, Context>,
      {
         id: 'version',
         columns: [{ id: 'version', head: 'Version', render: v => v.versionId }],
         getChildren: v => v.usages,
         getId: v => v.versionId,
      } as LevelConfig<Secret, Version, Usage, Context>,
      {
         id: 'usages',
         columns: [
            { id: 'usage', className: 'usages', head: 'Usages', render: v => v.path, isHidden: c => c.hideUsages },
            { id: 'key', className: 'key', head: 'Key', render: v => v.key, isHidden: true },
         ],
         // getChildren: v => v.key.split(''),
         getId: v => v.path,
      } as LevelConfig<Version, Usage, string, Context>,
      // {
      //    columns: [{ head: 'letter', render: v => v }],
      //    getId: v => v,
      // } as LevelConfig<Usage, string, void, Context>,
   ],
};

const Template: Story<{ disabled: boolean; readonly: boolean; hideUsages: boolean }> = ({
   disabled,
   readonly,
   hideUsages,
}) => (
   <HierarchicalTable
      values={values}
      config={config}
      context={{ ...context, hideUsages }}
      disabled={disabled}
      readonly={readonly}
      data-e2e={'story'}
   />
);

export const Regular = Template.bind({});

Regular.storyName = 'HierarchicalTable'; // Remove if it isn't single story
Regular.args = {
   disabled: false,
   readonly: false,
   hideUsages: false,
};

export default {
   title: 'components/lib/HierarchicalTable',
} as Meta;
