import { CheckboxSelectionItem, classNames } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { LegoCheckBox } from '../../../_lego';

import classes from './HierarchicalTable.module.css';
import { Cell, Column, Row } from './models';
import { LevelConfig } from './publicModels';

export function isColumnHidden(column: Column<any, any, any>, context: any) {
   if (column.isHidden === true) {
      return true;
   }

   return typeof column.isHidden === 'function' && column.isHidden(context);
}

interface ConvertToRowsParams {
   addCheckbox: boolean;
   context: any;
   disabled: boolean;
   levelConfigs: LevelConfig<any, any, any, any>[];
   parent: any;
   values: any[];
}

export function convertToRows({
   addCheckbox,
   context,
   disabled,
   levelConfigs,
   parent,
   values,
}: ConvertToRowsParams): Row[] {
   const result: Row[] = [];

   for (const value of values) {
      for (let levelIndex = 0; levelIndex < levelConfigs.length; levelIndex += 1) {
         const levelConfig = levelConfigs[levelIndex];
         const valueId = levelConfig.getId(value);

         let childrenRows: Row[] = [];
         if (levelConfig.getChildren) {
            const children = levelConfig.getChildren?.(value) ?? [];
            childrenRows = convertToRows({
               addCheckbox: false,
               context,
               disabled,
               levelConfigs: levelConfigs.slice(levelIndex + 1),
               parent: value,
               values: children,
            });
         }

         const rowSpan = childrenRows.length > 0 ? childrenRows.length : 1;

         const cells: Cell[] = levelConfig.columns
            .filter(column => !isColumnHidden(column, context))
            .map(({ id, render, cellClassName, cellClassNameFn }) => ({
               className: classNames(cellClassName, cellClassNameFn?.(value, parent, context)),
               colSpan: 1,
               content: render(value, parent, context),
               id,
               rowSpan,
            }));

         if (addCheckbox) {
            cells.unshift({
               className: classes.checkboxCell,
               colSpan: 1,
               content: (
                  <CheckboxSelectionItem id={valueId}>
                     {({ selected, toggle }) => (
                        <LegoCheckBox checked={selected} onChange={toggle} disabled={disabled} />
                     )}
                  </CheckboxSelectionItem>
               ),
               id: 'checkbox',
               rowSpan,
            });
         }

         const thisRow: Row = { cells, id: valueId };

         if (childrenRows.length > 0) {
            const [first, ...rest] = childrenRows;

            first.id = valueId;
            first.cells.unshift(...cells);
            first.className = classNames(first.className, classes.first);

            result.push(first, ...rest);
            break;
         } else {
            // if (levelConfig.getChildren) {
            thisRow.className = classNames(thisRow.className, classes.first);
            // }
            result.push(thisRow);
         }
      }
   }

   return result;
}
