import { ReactNode } from 'react';

export interface Column<TParent, TThis, TContext> {
   cellClassName?: string;
   cellClassNameFn?: (value: TThis, parent: TParent | null, context: TContext) => string;
   className?: string;
   id: string;
   head: ReactNode;

   render(value: TThis, parent: TParent | null, context: TContext): ReactNode;

   isHidden?: boolean | ((context: TContext) => boolean);
}

export interface Cell {
   className?: string;
   colSpan: number;
   content: ReactNode;
   id: string | number;
   rowSpan: number;
}

export interface Row {
   cells: Cell[];
   className?: string;
   id: string | number;
}
