import { Meta } from '@storybook/react';
import React from 'react';
import { MiniBox } from './MiniBox';

const largeText = `Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque suscipit enim eget orci imperdiet, ut commodo enim molestie. Aliquam bibendum risus tortor, eget mattis lacus vulputate et. Nulla vel posuere metus. Integer viverra malesuada libero ac facilisis. Nunc erat arcu, eleifend nec ante vitae, pulvinar ultricies eros. Donec blandit, eros sed posuere convallis, turpis est tristique ex, nec aliquam mauris ex quis neque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam id aliquam neque. Morbi consequat et eros quis porta. Duis pellentesque suscipit neque. Nulla quis ornare quam. Curabitur ut magna semper, tempus ante quis, vulputate mi. Sed eros turpis, rutrum auctor tortor quis, gravida vulputate arcu. Vestibulum nec odio id sem vestibulum hendrerit non vitae lacus. Morbi interdum mi vel lacus mattis, a mollis arcu bibendum.

In scelerisque, est varius auctor volutpat, ex est sodales turpis, in luctus mi lectus at lacus. Praesent eleifend libero ac tellus hendrerit lobortis. Quisque non ipsum id risus luctus lacinia. Quisque sed libero nec mauris laoreet ultricies. Morbi dapibus varius turpis sit amet convallis. Pellentesque sem nunc, congue quis iaculis nec, pulvinar in nunc. Proin rutrum, turpis sit amet viverra finibus, purus leo accumsan justo, ac dignissim nisi tellus non erat. Sed sit amet ultrices nisl. Maecenas at urna congue, cursus justo posuere, bibendum sapien. Sed posuere, ipsum vitae posuere suscipit, diam nunc molestie est, at dictum lacus ligula non augue. Etiam blandit turpis et sapien molestie, volutpat vehicula velit fermentum. Praesent nec est eu massa mollis auctor. Curabitur vel nulla risus. Sed at commodo sem. Sed vitae scelerisque nunc.

Nulla facilisi. In ligula libero, eleifend et scelerisque ac, semper eu metus. Aenean vulputate, turpis sed ultricies suscipit, tortor nibh sodales velit, vel sagittis ante justo rutrum lacus. In tempor tristique congue. Integer ultrices, libero vel eleifend posuere, neque ligula semper risus, nec lacinia nunc felis nec dui. Duis suscipit iaculis augue ut luctus. Nulla orci ante, venenatis id accumsan eget, interdum at turpis. Morbi pellentesque dapibus leo, rutrum lobortis orci aliquet finibus. Praesent eu pellentesque justo, a congue nisl.`;

const smallText = 'Hello, world!';

export const TextMode = () => (
   <div>
      <h2>height=200px width=400px</h2>
      <h4>Large text</h4>
      <MiniBox preferenceMode={'text'} showMoreTitle={'show all'} height={'200px'} width={'400px'}>
         {largeText}
      </MiniBox>
      <h4>Small text</h4>
      <MiniBox preferenceMode={'text'} showMoreTitle={'show all'} height={'200px'} width={'400px'}>
         {smallText}
      </MiniBox>
      <h2>height=3em width=90%</h2>
      <h4>Large text</h4>
      <MiniBox preferenceMode={'text'} showMoreTitle={'show all'} height={'3em'} width={'90%'}>
         {largeText}
      </MiniBox>
      <h4>Small text</h4>
      <MiniBox preferenceMode={'text'} showMoreTitle={'show all'} height={'3em'} width={'90%'}>
         {smallText}
      </MiniBox>
   </div>
);

export const BlockMode = () => (
   <div>
      <h2>height=200px width=400px</h2>
      <h4>Large text</h4>
      <MiniBox preferenceMode={'block'} showMoreTitle={'show all'} height={'200px'} width={'400px'}>
         {largeText}
      </MiniBox>
      <h4>Small text</h4>
      <MiniBox preferenceMode={'block'} showMoreTitle={'show all'} height={'200px'} width={'400px'}>
         {smallText}
      </MiniBox>
      <h2>height=3em width=90%</h2>
      <h4>Large text</h4>
      <MiniBox preferenceMode={'block'} showMoreTitle={'show all'} height={'3em'} width={'90%'}>
         {largeText}
      </MiniBox>
      <h4>Small text</h4>
      <MiniBox preferenceMode={'block'} showMoreTitle={'show all'} height={'3em'} width={'90%'}>
         {smallText}
      </MiniBox>
   </div>
);

export default {
   title: 'components/lib/MiniBox',
   component: MiniBox,
} as Meta;
