import { faLongArrowRight } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import React, { Fragment, ReactNode } from 'react';

import classes from './OrderList.module.css';

export const OrderList: React.FC<{ items: ReactNode[]; separator?: ReactNode }> = React.memo(({ items, separator }) => (
   <div className={classes.list}>
      {items.map((item, i) => (
         // eslint-disable-next-line react/no-array-index-key
         <Fragment key={i}>
            {i > 0 && (separator ?? <FontAwesomeIcon icon={faLongArrowRight} />)}
            {item}
         </Fragment>
      ))}
   </div>
));
