import React from 'react';
import { Button } from '@yandex-cloud/uikit';

import classes from './PromoCard.module.css';

interface Props {
   title: string;
   links?: { text?: string; url: string }[];
}

export const PromoCard: React.FC<Props> = React.memo(({ title, children, links }) => (
   <div className={classes.card}>
      <h3>{title}</h3>
      {children}
      <div className={classes.actions}>
         {links?.map(({ url, text }) => (
            <a href={url} target={'_blank'} rel={'noopener noreferrer'}>
               {text ? <Button view={'normal-contrast'}>{text}</Button> : url}
            </a>
         ))}
      </div>
   </div>
));

PromoCard.displayName = 'PromoCard';
