import { action } from '@storybook/addon-actions';
import { Meta, Story } from '@storybook/react';
import { modalService } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useState } from 'react';

import { LegoButton } from '../../../_lego';
import { modalsSupportDecorator } from '../../../stories';
import { DevJson } from '../DevJson/DevJson';

import { PromptModal } from './PromptModal';

const Template: Story<{ title: string; subtitle: string }> = ({ title, subtitle }) => (
   <PromptModal title={title} subtitle={subtitle} ok={action('ok')} cancel={action('cancel')} initialValue={'xxx'} />
);

export const Layout = Template.bind({});
Layout.args = {
   title: 'title',
   subtitle: 'subtitle',
};

export const OpenModal = () => {
   const [value, setValue] = useState('');

   const open = useCallback(() => {
      modalService
         .open(PromptModal, { title: 'Enter value', initialValue: 'initial' })
         .subscribe(setValue, action('dismiss'));
   }, []);

   return (
      <>
         <LegoButton onClick={open}>Open modal</LegoButton>
         <DevJson>{value}</DevJson>
      </>
   );
};

export default {
   decorators: [modalsSupportDecorator],
   title: 'components/lib/PromptModal',
} as Meta;
