import { IModalProps, ModalLayout } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useState } from 'react';

import { LegoTextInput } from '../../../_lego';

interface Props extends IModalProps<string> {
   title: string;
   subtitle?: string;
   'data-e2e'?: string;
   initialValue: string;
}

export const PromptModal: React.FC<Props> = React.memo(
   ({ initialValue, title, subtitle, ok, cancel, 'data-e2e': dataE2E }) => {
      const [value, setValue] = useState(initialValue);

      const handleOk = useCallback(() => ok(value), [ok, value]);

      const handleClose = useCallback(() => cancel(), [cancel]);

      return (
         <ModalLayout title={title} subtitle={subtitle} onOk={handleOk} onDismiss={handleClose} data-e2e={dataE2E}>
            <LegoTextInput text={value} onChange={setValue} />
         </ModalLayout>
      );
   },
);

PromptModal.displayName = 'PromptModal';
