import React, { useContext, useEffect } from 'react';
import { SharedNodeContext } from './SharedButtonsContext';

interface Props {
   replace?: boolean;
}

export const EditSharedNode: React.FC<Props> = ({ replace = false, children }) => {
   const context = useContext(SharedNodeContext);
   if (!context) {
      throw new Error('You should use <SharedNode/> in parent component');
   }

   useEffect(() => context.setNewNode(children, replace), [children, context, replace]);

   return null;
};

EditSharedNode.displayName = 'EditSharedNode';
