import React, { ReactNode, RefObject } from 'react';
import ReactDOM from 'react-dom';

export class SharedNodeContextValue {
   public forceRender: () => () => void;

   private node: ReactNode;

   private replace = false;

   constructor(forceRender: (value: (r: number) => number) => void) {
      this.forceRender = () => {
         // raf for avoid infinite loop
         const n = window.requestAnimationFrame(() => forceRender(r => r + 1));

         return () => window.cancelAnimationFrame(n);
      };
   }

   public setNewNode(node: ReactNode, replace: boolean) {
      this.node = node;
      this.replace = replace;

      this.forceRender();

      return () => this.reset();
   }

   public renderPortal(ref: RefObject<HTMLDivElement>, common: ReactNode = null) {
      if (!ref.current) {
         return null;
      }

      return ReactDOM.createPortal(
         <>
            {this.node ?? null}
            {this.replace ? null : common}
         </>,
         ref.current,
      );
   }

   private reset() {
      this.node = null;
      this.replace = false;

      this.forceRender();
   }
}

export const SharedNodeContext = React.createContext<SharedNodeContextValue | null>(null);
