import React, { ReactNode, RefObject, useEffect, useMemo, useState } from 'react';

import { SharedNodeContext, SharedNodeContextValue } from './SharedButtonsContext';

interface Props {
   common?: ReactNode;
   nodeRef: RefObject<HTMLDivElement>;
}

export const SharedNodeProvider: React.FC<Props> = ({ common, children, nodeRef }) => {
   const [, forceRender] = useState(0);

   const value = useMemo(() => new SharedNodeContextValue(forceRender), []);

   useEffect(() => value.forceRender(), [value]);

   return (
      <>
         <SharedNodeContext.Provider value={value}>{children}</SharedNodeContext.Provider>

         {value.renderPortal(nodeRef, common)}
      </>
   );
};

SharedNodeProvider.displayName = 'SharedNode';
