import { DISMISS_REASON, IModalProps, ModalLayout } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';

interface Props extends IModalProps<unknown> {
   title: string;
   dataE2e?: string;
}

export const SimpleModal: React.FC<Props> = React.memo(({ title, cancel, children, dataE2e }) => {
   const dismiss = useCallback(() => cancel(DISMISS_REASON), [cancel]);

   return (
      <ModalLayout data-e2e={dataE2e} onDismiss={dismiss} showFooter={false} title={title}>
         {children}
      </ModalLayout>
   );
});

SimpleModal.displayName = 'SimpleModal';
