import { classNames, useDropdownDimensions } from '@yandex-infracloud-ui/libs';
import { Popup, PopupDirection } from 'lego-on-react';
import React, { ReactNode, RefObject, useCallback, useRef, useState } from 'react';

import { handleStopPropagation } from '../../../utils';
import classes from './SimplePopup.module.css';

interface Props {
   className?: string;
   dataTest?: string;
   directions?: PopupDirection[];
   disabled?: boolean;
   limitPopupWidth?: boolean;
   popupClassName?: string;
   switcher: ReactNode;
}

export const SimplePopup: React.FC<Props> = React.memo(
   ({ disabled, dataTest, limitPopupWidth, switcher, children, className, popupClassName, directions }) => {
      const [visible, setVisible] = useState(false);
      const switcherRef = useRef<HTMLSpanElement>();
      const [width, maxHeight] = useDropdownDimensions(switcherRef);

      const open = useCallback(() => setVisible(true), []);
      const close = useCallback(() => setVisible(false), []);
      const getAnchor = useCallback(() => switcherRef.current, []);

      return (
         <>
            <span
               ref={switcherRef as RefObject<HTMLSpanElement>}
               className={classNames(classes.switcher, className)}
               onClick={disabled ? undefined : open}
            >
               {switcher}
            </span>

            <Popup
               theme={'normal'}
               target={'anchor'}
               directions={directions ?? ['bottom-left']}
               visible={visible}
               onClose={close}
               onOutsideClick={close}
               anchor={getAnchor}
               cls={popupClassName}
            >
               <div
                  style={{
                     [limitPopupWidth ? 'width' : 'minWidth']: width,
                     maxHeight,
                     overflowY: 'auto',
                  }}
                  onScroll={handleStopPropagation}
                  data-test={dataTest}
               >
                  {children}
               </div>
            </Popup>
         </>
      );
   },
);

SimplePopup.displayName = 'SimplePopup';
