import { Meta } from '@storybook/react';
import React from 'react';
import { Status, StatusState, StatusType } from './Status';

export const primary = () => (
   <div>
      <div>
         <Status state={StatusState.Ok} type={StatusType.Primary} />
      </div>
      <div>
         <Status state={StatusState.Error} type={StatusType.Primary} />
      </div>
      <div>
         <Status state={StatusState.Progress} type={StatusType.Primary} />
      </div>
      <div>
         <Status state={StatusState.Inactive} type={StatusType.Primary} />
      </div>
      <div>
         <Status state={StatusState.Planned} type={StatusType.Primary} />
      </div>
      <div>
         <Status state={StatusState.Default} type={StatusType.Primary} />
      </div>
      <div>
         <Status state={StatusState.Unknown} type={StatusType.Primary} />
      </div>
   </div>
);

export const secondary = () => (
   <>
      <div>
         <Status state={StatusState.Ok} />
      </div>
      <div>
         <Status state={StatusState.Error} />
      </div>
      <div>
         <Status state={StatusState.Progress} />
      </div>
      <div>
         <Status state={StatusState.Inactive} />
      </div>
      <div>
         <Status state={StatusState.Planned} />
      </div>
      <div>
         <Status state={StatusState.Default} />
      </div>
      <div>
         <Status state={StatusState.Unknown} />
      </div>
   </>
);

export const secondaryWithSign = () => (
   <>
      <div>
         <Status state={StatusState.Ok} sign />
      </div>
      <div>
         <Status state={StatusState.Error} sign />
      </div>
      <div>
         <Status state={StatusState.Progress} sign />
      </div>
      <div>
         <Status state={StatusState.Inactive} sign />
      </div>
      <div>
         <Status state={StatusState.Planned} sign />
      </div>
      <div>
         <Status state={StatusState.Default} sign />
      </div>
      <div>
         <Status state={StatusState.Unknown} sign />
      </div>
   </>
);

export default {
   title: 'components/lib/Status',
} as Meta;
