import { Meta } from '@storybook/react';
import React from 'react';
import { Status, StatusState, StatusType } from '../Status/Status';
import { StatusLabel } from './StatusLabel';

export const label = () => (
   <div>
      <p>
         <StatusLabel state={StatusState.Ok}>
            <Status state={StatusState.Ok} type={StatusType.Secondary} />
         </StatusLabel>
      </p>
      <p>
         <StatusLabel state={StatusState.Error}>
            <Status state={StatusState.Error} type={StatusType.Secondary} />
         </StatusLabel>
      </p>
      <p>
         <StatusLabel state={StatusState.Progress}>
            <Status state={StatusState.Progress} type={StatusType.Secondary} />
         </StatusLabel>
      </p>
      <p>
         <StatusLabel state={StatusState.Inactive}>
            <Status state={StatusState.Inactive} type={StatusType.Secondary} />
         </StatusLabel>
      </p>
      <p>
         <StatusLabel state={StatusState.Planned}>
            <Status state={StatusState.Planned} type={StatusType.Secondary} />
         </StatusLabel>
      </p>
      <p>
         <StatusLabel state={StatusState.Default}>
            <Status state={StatusState.Default} type={StatusType.Secondary} />
         </StatusLabel>
      </p>
      <p>
         <StatusLabel state={StatusState.Unknown}>
            <Status state={StatusState.Unknown} type={StatusType.Secondary} />
         </StatusLabel>
      </p>
   </div>
);

export default {
   title: 'components/lib/StatusLabel',
   component: StatusLabel,
} as Meta;
