import { Label, LabelProps } from '@yandex-cloud/uikit';
import React from 'react';
import { StatusState } from '../Status/Status';

import classes from './StatusLabel.module.css';

const labelTheme: Record<StatusState, LabelProps['theme']> = {
   [StatusState.Error]: 'danger',
   [StatusState.Progress]: 'info',
   [StatusState.Default]: 'normal',
   [StatusState.Inactive]: 'unknown',
   [StatusState.Ok]: 'success',
   [StatusState.Pause]: 'warning',
   [StatusState.Planned]: 'warning',
   [StatusState.Unknown]: 'unknown',
};

interface Props {
   state: StatusState;
   text?: string;
   onClick?(event: React.MouseEvent<HTMLDivElement, MouseEvent>): void;
}

export const StatusLabel: React.FC<Props> = React.memo(({ state, text, onClick, children }) => (
   <div className={classes.label} title={text ?? state}>
      <Label theme={labelTheme[state]} onClick={onClick}>
         {children ?? state}
      </Label>
   </div>
));

StatusLabel.displayName = 'StatusLabel';
