import React from 'react';
import { classNames } from '@yandex-infracloud-ui/libs';
import { stateStyles, StatusState } from '../Status/Status';

import classes from './StatusMap.module.css';

export interface StatusInfo {
   status: StatusState;
   title?: string;
   onClick?(): void;
}

export interface StatusMapProps {
   statuses: StatusInfo[];
}

export const StatusMap: React.FC<StatusMapProps> = React.memo(({ statuses }) => (
   <div className={classes.map}>
      {statuses.map((statusInfo, i) => {
         const { status, title, onClick } = statusInfo;

         return (
            <div
               key={`${status}-${String(i)}`}
               className={classNames(classes.ceil, stateStyles[status])}
               title={title ?? status}
               onClick={onClick}
               role={'button'}
               tabIndex={0}
               aria-label={'status'}
            />
         );
      })}
   </div>
));

StatusMap.displayName = 'StatusMap';
