import { faMoon, faSun } from '@fortawesome/free-solid-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { ThemeContext } from '@yandex-cloud/uikit';
import React, { useCallback, useContext } from 'react';

import classes from './ThemeSwitch.module.css';

export const ThemeSwitch: React.FC = () => {
   const themeContext = useContext(ThemeContext);
   const setTheme = useCallback(
      (theme: 'light' | 'dark') => {
         localStorage.setItem('theme', theme);
         themeContext.setTheme(theme);
      },
      [themeContext],
   );

   if (themeContext.theme === 'light') {
      return (
         <FontAwesomeIcon
            icon={faMoon}
            title={'Dark theme'}
            className={classes.themeSwitch}
            onClick={() => setTheme('dark')}
         />
      );
   }

   return (
      <FontAwesomeIcon
         icon={faSun}
         title={'Light theme'}
         className={classes.themeSwitch}
         onClick={() => setTheme('light')}
      />
   );
};

ThemeSwitch.displayName = 'ThemeSwitch';
