import { classNames } from '@yandex-infracloud-ui/libs';
import React from 'react';

import classes from './UserLink.module.scss';

interface Props {
   id: string;
   className?: string;
}

// TODO khoden: в либе уже есть компонент c подобной функциональностью
export const UserLink: React.FC<Props> = React.memo(
   Object.assign(
      ({ id, className }: Props) => (
         <a
            key={id}
            href={`https://staff.yandex-team.ru/${id}`}
            target={'_blank'}
            rel={'noopener noreferrer'}
            className={classNames(classes.link, className)}
         >
            <span className={classes.firstLetter}>{id[0]}</span>
            {id.slice(1)}
         </a>
      ),
      { displayName: 'UserLink' },
   ),
);
