import { ApiCache, BaseApi, HttpMethod, IApiError } from '@yandex-infracloud-ui/libs';
import { map, Observable } from 'rxjs';

import { EndpointSchema } from './models/EndpointSchema';
import { GetQueryContextKeysRequest } from './models/GetQueryContextKeysRequest';
import { GetQueryContextKeysResponse } from './models/GetQueryContextKeysResponse';
import { GetSearchQuerySuggestsRequest } from './models/GetSearchQuerySuggestsRequest';
import { GetSearchQuerySuggestsResponse } from './models/GetSearchQuerySuggestsResponse';
import { currentIndexSymbol, currentTokenSymbol } from './models/LogEntry';
import { SearchLogEntriesRequest } from './models/SearchLogEntriesRequest';
import { SearchLogEntriesResponse, SearchLogEntriesResponseSnake } from './models/SearchLogEntriesResponse';

export class LogApi extends BaseApi {
   private cache = new ApiCache();

   public searchLogEntries(params: SearchLogEntriesRequest): Observable<SearchLogEntriesResponse> {
      return this.request<void, SearchLogEntriesRequest, SearchLogEntriesResponse>(
         HttpMethod.POST,
         'SearchLogEntries/',
         undefined,
         params,
      ).pipe(
         map(r => {
            r.logEntries = r.logEntries.map((logEntry, i) => {
               logEntry[currentTokenSymbol] = r.continuationTokens?.current;
               logEntry[currentIndexSymbol] = i;

               return logEntry;
            });

            return r;
         }),
      );
   }

   public searchLogEntriesSnake(params: SearchLogEntriesRequest): Observable<SearchLogEntriesResponseSnake> {
      return this.request<void, SearchLogEntriesRequest, SearchLogEntriesResponseSnake>(
         HttpMethod.POST,
         'SearchLogEntries/?_snake_case=true',
         undefined,
         params,
      ).pipe(
         map(r => {
            r.log_entries = r.log_entries.map((logEntry, i) => {
               logEntry[currentTokenSymbol] = r.continuation_tokens?.current;
               logEntry[currentIndexSymbol] = i;

               return logEntry;
            });

            return r;
         }),
      );
   }

   public getQueryContextKeys(params: GetQueryContextKeysRequest): Observable<string[]> {
      return this.request<void, GetQueryContextKeysRequest, GetQueryContextKeysResponse>(
         HttpMethod.POST,
         'GetQueryContextKeys/',
         undefined,
         params,
      ).pipe(map(r => r.candidates.filter(Boolean)));
   }

   public getSearchQuerySuggests(params: GetSearchQuerySuggestsRequest): Observable<string[]> {
      return this.request<void, GetSearchQuerySuggestsRequest, GetSearchQuerySuggestsResponse>(
         HttpMethod.POST,
         'GetSearchQuerySuggests/',
         undefined,
         params,
      ).pipe(map(r => r.candidates.filter(Boolean)));
   }

   public getSchema(): Observable<EndpointSchema[]> {
      return this.cache.request('schema', () => this.request(HttpMethod.GET, ''));
   }

   protected getCSRF(): string {
      return '';
   }

   // eslint-disable-next-line
   protected handleError(resp: Response, error: IApiError): void {}
}
