import { Order } from '../../../smart-table';
import { IntervalValue } from '../../filters/IntervalFilter/IntervalFilter';

import { ArrayRequestParam } from './ArrayRequestParam';

interface TimestampRange {
   begin?: string;
   end?: string;
}

export function intervalToRange({ from, to }: IntervalValue): TimestampRange | undefined {
   return from?.absolute || to?.absolute ? { begin: from?.absolute?.toJSON(), end: to?.absolute?.toJSON() } : undefined;
}

/**
 * Фильтры при запросе как самого лога, так и кандидатов для подсказок
 */
export interface RequestParams {
   limit?: number;
   order?: Order;
   timestampRange?: TimestampRange;

   [field: `${string}List`]: ArrayRequestParam;

   [field: string]: string | any; // any for TS
}
