import { Meta, Story } from '@storybook/react';
import * as React from 'react';

import { TimeCell } from './TimeCell';

const Template: Story<{ value: Date | null }> = ({ value }) => <TimeCell rowEntry={{ value }} columnName={'value'} />;

export const Default = Template.bind({});
Default.args = { value: new Date() };

export const Empty = Template.bind({});
Empty.args = { value: null };

export default {
   title: 'log-page/cells/TimeCell',
} as Meta;
