import { EMPTY_VALUE, formatDate } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useMemo } from 'react';

import { CellProps } from '../../../smart-table';

import classes from './TimeCell.module.css';

export const TimeCell: React.FC<CellProps> = React.memo(({ rowEntry, columnName }) => {
   const date = useMemo(() => {
      const v = rowEntry[columnName];

      return v ? (v instanceof Date ? v : new Date(v)) : null;
   }, [columnName, rowEntry]);

   return (
      <div className={classes.time} title={date ? formatDate(date, 'yyyy-MM-dd HH:mm:ss.SSS') : undefined}>
         {date ? (
            <>
               {formatDate(date, 'HH:mm:ss')}
               <span className={classes.timeMillis}>{formatDate(date, '.SSS')}</span>
            </>
         ) : (
            EMPTY_VALUE
         )}
      </div>
   );
});

TimeCell.displayName = 'TimeCell';
