import { ComponentMeta, Story } from '@storybook/react';
import * as React from 'react';

import { LogApi } from '../../api/LogApi';
import { AWACS_LOG_ENDPOINT, DEPLOY_LOG_ENDPOINT } from '../../constants';
import { QueryProvider } from '../../query/provider/QueryProvider';
import { LogPageProvider } from '../../useLogPageContext';

import { ClickableJson, ClickableJsonProps } from './ClickableJson';

const Template: Story<ClickableJsonProps> = props => <ClickableJson {...props} />;

const awacsQueryProvider = new QueryProvider(new LogApi(AWACS_LOG_ENDPOINT));
const awacsLogEntry = {
   clientIp: '2a02:6b8:0:1a00::3b8a',
   clientPort: 18861,
   cookies: '{}',
   domain: '',
   envType: 'NS_ENV_UNKNOWN',
   headers: '{}',
   hostname: 'anttsov-test-balancer.yandex-team.ru',
   method: 'GET',
   processTime: 0,
   pushclientRowId: '-4',
   reason: 'errordocument',
   request: '/ping',
   requestId: '',
   status: 200,
   timestamp: '2021-09-30T10:51:27.844707Z',
   upstream: 'default',
   workflow:
      '[meta awacs-test <::upstream:default::> <::env_type:NS_ENV_UNKNOWN::> <::namespace:anttsov-test-balancer-ns::> [report u:service_total [cookie_policy u:service_total [regexp slbping [errordocument succ 200]]]]]',
   yandexuid: '',
};

export const Awacs = Template.bind({});
Awacs.decorators = [
   ThisStory => (
      <LogPageProvider value={{ queryProvider: awacsQueryProvider }}>
         <ThisStory />
      </LogPageProvider>
   ),
];
Awacs.args = {
   value: awacsLogEntry,
};

const deployQueryProvider = new QueryProvider(new LogApi(DEPLOY_LOG_ENDPOINT));
const deployLogEntry = {
   box: 'box',
   stackTrace: 'debug test stack trace (1627290280099)',
   workload: 'WorkloadJsonLogs',
   containerId: 'pod_agent_box_box/workload_WorkloadJsonLogs_start',
   seq: '18446744073709538115',
   logLevel: 'DEBUG',
   timestamp: '2022-06-01T10:53:24.536133Z',
   podPersistentFqdn: 'w3yabiy2ygkfafcp.sas.yp-c.yandex.net',
   threadName: '',
   userId: '',
   loggerName: 'debug',
   nodeFqdn: 'sas1-4407.search.yandex.net',
   host: 'sas1-4407-3.w3yabiy2ygkfafcp.sas.yp-c.yandex.net',
   requestId: 'debug request',
   context:
      '{"status":{"code":200,"message":"OK"},"context":{"minus-minus":"debug minus","space space":"debug space","context":"debug context","dot.dot":"debug dot"},"level":"DEBUG"}',
   podTransientFqdn: 'sas1-4407-3.w3yabiy2ygkfafcp.sas.yp-c.yandex.net',
   pod: 'w3yabiy2ygkfafcp',
   message: 'debug test message (1627290280099)',
   logLevelInt: '0',
};

export const Deploy = Template.bind({});
Deploy.decorators = [
   ThisStory => (
      <LogPageProvider value={{ queryProvider: deployQueryProvider }}>
         <ThisStory />
      </LogPageProvider>
   ),
];
Deploy.args = {
   value: deployLogEntry,
};

export default {
   component: ClickableJson,
   title: 'log-page/ClickableJson',
} as ComponentMeta<typeof ClickableJson>;
