import { Button, ButtonView } from '@yandex-cloud/uikit';
import * as React from 'react';

import { Operator, queryOperatorMap } from '../../../query';

interface Props {
   className?: string;
   operator: Operator;
   view?: ButtonView;

   onClick(v: Operator): void;
}

export const ClickableJsonOperatorButton: React.FC<Props> = ({ className, operator, onClick, view }) => (
   <Button title={operator} onClick={() => onClick(operator)} view={view} className={className}>
      {queryOperatorMap[operator]}
   </Button>
);

ClickableJsonOperatorButton.displayName = 'ClickableJsonOperatorButton';
