import { action } from '@storybook/addon-actions';
import { Meta, Story } from '@storybook/react';
import * as React from 'react';

import { ClickableJsonValue } from './ClickableJsonValue';

const Template: Story<{ value: any }> = ({ value }) => (
   <ClickableJsonValue clickable={true} greppable={false} onClick={action('onClick')}>
      {value}
   </ClickableJsonValue>
);

export const String = Template.bind({});
String.args = { value: 'string' };

export const Null = Template.bind({});
Null.args = { value: null };

export const Number = Template.bind({});
Number.args = { value: 125 };

export default {
   title: 'log-page/ClickableJson/_value',
} as Meta;
