import { Popup } from '@yandex-cloud/uikit';
import { classNames } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useCallback, useRef, useState } from 'react';

import { Operator } from '../../../query';
import { ClickableJsonOperatorButton } from '../__operatorButton/ClickableJsonOperatorButton';

import classes from './ClickableJsonValue.module.css';

interface Props {
   children: any;
   className?: string;
   clickable: boolean;
   greppable: boolean;

   onClick(operator: Operator): void;
}

export const ClickableJsonValue: React.FC<Props> = ({ clickable, greppable, className, children: value, onClick }) => {
   const [open, setOpen] = useState(false);
   const switcherRef = useRef<HTMLSpanElement>(null);
   const handleOpen = useCallback(() => setOpen(true), []);
   const handleClose = useCallback(() => setOpen(false), []);
   const handleClick = useCallback(
      (operator: Operator) => {
         setOpen(false);
         onClick(operator);
      },
      [onClick],
   );

   return (
      <>
         {clickable && (
            <Popup
               anchorRef={switcherRef}
               hasArrow={true}
               onOutsideClick={handleClose}
               open={open}
               placement={['bottom']}
            >
               <div className={classes.popup}>
                  <ClickableJsonOperatorButton view={'action'} operator={Operator.Equal} onClick={handleClick} />
                  <ClickableJsonOperatorButton operator={Operator.NotEqual} onClick={handleClick} />

                  {greppable && (
                     <>
                        <ClickableJsonOperatorButton operator={Operator.Grep} onClick={handleClick} />
                        <ClickableJsonOperatorButton operator={Operator.NotGrep} onClick={handleClick} />
                     </>
                  )}
               </div>
            </Popup>
         )}
         <span
            className={classNames(classes.wrapper, classes[typeof value], className, {
               [classes.clickable]: clickable,
            })}
            onClick={clickable ? handleOpen : undefined}
            ref={switcherRef}
            role={'button'}
            tabIndex={0}
         >
            {JSON.stringify(value)}
         </span>
      </>
   );
};

ClickableJsonValue.displayName = 'ClickableJsonValue';
