import { ComponentMeta, Story } from '@storybook/react';
import * as React from 'react';

import { JsonOrString, JsonOrStringProps } from './JsonOrString';

const Template: Story<JsonOrStringProps> = props => <JsonOrString {...props} />;

export const Valid = Template.bind({});
Valid.args = { rawJson: '{"name":"khoden","age":100}' };

export const Invalid = Template.bind({});
Invalid.args = { rawJson: '{name:"khoden",age:100}' };

export const Empty = Template.bind({});
Empty.args = { rawJson: '' };

export const Null = Template.bind({});
Null.args = { rawJson: null };

export const Undefined = Template.bind({});
Undefined.args = { rawJson: undefined };

export default {
   component: JsonOrString,
   title: 'log-page/components/JsonOrString',
} as ComponentMeta<typeof JsonOrString>;
