import { EMPTY_VALUE, Json } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useMemo } from 'react';

import { safeParseJson } from '../../helpers/safeParseJson';

import classes from './JsonOrString.module.css';

export interface JsonOrStringProps {
   rawJson: string | null | undefined;
}

export const JsonOrString: React.FC<JsonOrStringProps> = React.memo(({ rawJson }) => {
   const value = useMemo(() => safeParseJson(rawJson), [rawJson]);

   return typeof value === 'string' ? (
      <span>{value || EMPTY_VALUE}</span>
   ) : (
      <div className={classes.json}>
         <Json obj={value} hidePre={true} />
      </div>
   );
});

JsonOrString.displayName = 'JsonOrString';
