import * as React from 'react';

import type { FilterProps } from '../../../smart-table/models';
import { PlainObject } from '../../../smart-table/models';
import type { QueryValue } from '../../query';
import { LogQueryInput } from '../../query';

import classes from './QueryFilter.module.css';

const QueryFilterImpl: React.FC<FilterProps<QueryValue>> = ({ value, onUpdate }) => (
   <div className={classes.wrapper}>
      <LogQueryInput value={value} onUpdate={onUpdate} />
   </div>
);

export const QueryFilter = Object.assign(QueryFilterImpl, {
   getValueFromUrlParams(urlParams: PlainObject): QueryValue {
      return { query: urlParams.query ?? '', request: {} };
   },
   setUrlParamsFromValue(v: QueryValue | undefined): PlainObject {
      const result: PlainObject = {};

      if (v?.query) {
         result.query = v.query;
      }

      return result;
   },
});
