import { safeParseJson } from './safeParseJson';

describe('safeParseJson', () => {
   interface Person {
      age: number;
      name: string;
   }

   const person: Person = {
      name: 'khoden',
      age: 100,
   };

   it('should parse regular JSON', () => {
      const rawJson = `{"name":"khoden","age":100}`;

      expect(safeParseJson<Person>(rawJson)).toEqual(person);
   });

   it('should return string if not parsable', () => {
      const rawJson = `{"name":"khoden",age:}`;

      expect(safeParseJson<Person>(rawJson)).toBe(rawJson);
   });

   it('should return string if just a string', () => {
      const rawJson = `Hello, World!`;

      expect(safeParseJson<Person>(rawJson)).toBe(rawJson);
   });

   it('should return null or undefined', () => {
      expect(safeParseJson('')).toBe('');
      expect(safeParseJson(null)).toBeNull();
      expect(safeParseJson(undefined)).toBeUndefined();
   });
});
