export function safeParseJson<T = any>(rawJson: string | undefined | null): T | string | null | undefined {
   if (!rawJson) {
      return rawJson;
   }

   try {
      return JSON.parse(rawJson) as T;
   } catch (e) {
      if (e instanceof SyntaxError) {
         return rawJson;
      }
      throw e;
   }
}
