import { ComponentMeta, Story } from '@storybook/react';
import * as React from 'react';
import { useState } from 'react';

import { modalsSupportDecorator } from '../../../../_storybook/decorators/modalsSupportDecorator';
import { LogApi } from '../../../api/LogApi';
import { AWACS_LOG_ENDPOINT } from '../../../constants';
import { LogPageContextValue, LogPageProvider } from '../../../useLogPageContext';
import { QueryProvider } from '../../provider/QueryProvider';

import { LogQueryInput, QueryValue } from './LogQueryInput';

const queryProvider = new QueryProvider(new LogApi(AWACS_LOG_ENDPOINT), {
   namespace: 'awacs',
});

const contextValue: LogPageContextValue = {
   queryProvider,
};

const Template: Story<{ query: string }> = ({ query }) => {
   const [value, setValue] = useState<QueryValue>({
      query,
      request: {},
   });

   return (
      <LogPageProvider value={contextValue}>
         <LogQueryInput value={value} onUpdate={setValue} />
      </LogPageProvider>
   );
};

export const Default = Template.bind({});
Default.args = { query: 'method=' };

export const Empty = Template.bind({});
Empty.args = { query: '' };

export const Highlighting = Template.bind({});
Highlighting.args = { query: 'key1=value1, "value2 with a=b lines"; key2!=value3;' };

export default {
   component: LogQueryInput,
   decorators: [modalsSupportDecorator],
   title: 'log-page/query/LogQueryInput',
} as ComponentMeta<typeof LogQueryInput>;
