import type { editor } from 'monaco-editor/esm/vs/editor/editor.api';

export const logQueryEditorOptions: editor.IStandaloneEditorConstructionOptions = {
   contextmenu: false,
   folding: false,
   fontFamily: 'var(--yc-font-family)',
   fontSize: 13,
   lineDecorationsWidth: '0px',
   lineHeight: 16,
   lineNumbers: 'off',
   minimap: { enabled: false },
   occurrencesHighlight: false,
   renderLineHighlight: 'none',
   scrollbar: {
      horizontal: 'hidden',
      horizontalScrollbarSize: 0,
      vertical: 'hidden',
      verticalScrollbarSize: 0,
   },
   suggest: { showIcons: false },
   suggestLineHeight: 26,
   wordBasedSuggestions: false,
   wordWrap: 'on',
   guides: {
      indentation: false,
      highlightActiveIndentation: false,
   },
   fixedOverflowWidgets: true,
};
