import { Meta, Story } from '@storybook/react';
import { Loader } from '@yandex-cloud/uikit';
import * as React from 'react';
import { useEffect, useState } from 'react';

import { LogApi } from '../../../api/LogApi';
import { AWACS_LOG_ENDPOINT, DEPLOY_LOG_ENDPOINT } from '../../../constants';
import { QueryProvider } from '../../provider/QueryProvider';

import { LogQuerySyntaxHint } from './LogQuerySyntaxHint';

const awacsProvider = new QueryProvider(new LogApi(AWACS_LOG_ENDPOINT));
const deployProvider = new QueryProvider(new LogApi(DEPLOY_LOG_ENDPOINT));

const Template: Story<{ queryProvider: QueryProvider }> = ({ queryProvider }) => {
   const [initiated, setInitiated] = useState(false);

   useEffect(() => {
      queryProvider.init(() => setInitiated(true));
   }, [queryProvider]);

   return initiated ? <LogQuerySyntaxHint fields={queryProvider.fields} /> : <Loader />;
};

export const Awacs = Template.bind({});
Awacs.args = { queryProvider: awacsProvider };

export const Deploy = Template.bind({});
Deploy.args = { queryProvider: deployProvider };

export default {
   title: 'log-page/query/LogQuerySyntaxHint',
} as Meta;
