import { toAst } from './ast';
import { getDiagramCode } from './parser';

// incorrect queries:
// message ==!!== abc
// mess age = a b
// message a b
// message = a b
// message = "a ;
// message = b " c "
// message = " c " d
// message = " d " " e "
// message = e , ""  f  ""
// message = , , ,

// FIXME:
// valid quoted values:
// "Search string with \"quotes\""
// "Search string with other punctuation characters (=,;!)";
// "HTTP/1.0\" "
// "escaping queries \"1\" \"2\" \"3\"        "

describe('grammars/query', () => {
   it('should parse simple query', () => {
      expect(toAst('a=b')).toMatchInlineSnapshot(`
         Array [
           Object {
             "key": "a",
             "operator": "Equal",
             "values": Array [
               "b",
             ],
           },
         ]
      `);
   });

   it('should parse quoted values', () => {
      expect(toAst('a=" a + b " ')).toMatchInlineSnapshot(`
         Array [
           Object {
             "key": "a",
             "operator": "Equal",
             "values": Array [
               " a + b ",
             ],
           },
         ]
      `);
   });

   it('should parse several values', () => {
      expect(toAst('a!="a + b", c,d;')).toMatchInlineSnapshot(`
         Array [
           Object {
             "key": "a",
             "operator": "NotEqual",
             "values": Array [
               "a + b",
               "c",
               "d",
             ],
           },
         ]
      `);
   });

   it('should parse grep operators', () => {
      expect(toAst('a~b')).toMatchInlineSnapshot(`
         Array [
           Object {
             "key": "a",
             "operator": "Grep",
             "values": Array [
               "b",
             ],
           },
         ]
      `);

      expect(toAst('a!~b')).toMatchInlineSnapshot(`
         Array [
           Object {
             "key": "a",
             "operator": "NotGrep",
             "values": Array [
               "b",
             ],
           },
         ]
      `);
   });

   it('should parse unfinished input', () => {
      expect(toAst('a')).toMatchInlineSnapshot(`
         Array [
           Object {
             "key": "a",
             "operator": undefined,
             "values": undefined,
           },
         ]
      `);

      expect(toAst('a b')).toMatchInlineSnapshot(`
         Array [
           Object {
             "key": "a",
             "operator": undefined,
             "values": undefined,
           },
           Object {
             "key": "b",
             "operator": undefined,
             "values": undefined,
           },
         ]
      `);

      expect(toAst('a= b c')).toMatchInlineSnapshot(`
         Array [
           Object {
             "key": "a",
             "operator": "Equal",
             "values": Array [
               "b",
             ],
           },
           Object {
             "key": "c",
             "operator": undefined,
             "values": undefined,
           },
         ]
      `);
   });

   it.skip('should dump to diagram', () => {
      const html = getDiagramCode();
      console.log(html);
   });
});
